/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item.itemblock;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.block.BlockController;
import com.raoulvdberge.refinedstorage.block.enums.ControllerType;
import com.raoulvdberge.refinedstorage.item.itemblock.ItemBlockBase;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ItemBlockController
extends ItemBlockBase {
    public ItemBlockController(BlockController block) {
        super(block, true);
        this.func_77625_d(1);
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        return 1.0 - (double)ItemBlockController.getEnergyStored(stack) / (double)RS.INSTANCE.config.controllerCapacity;
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)ItemBlockController.getEnergyStored(stack) / (float)RS.INSTANCE.config.controllerCapacity) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77960_j() != ControllerType.CREATIVE.getId();
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (stack.func_77960_j() != ControllerType.CREATIVE.getId()) {
            tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:energy_stored", (Object[])new Object[]{ItemBlockController.getEnergyStored(stack), RS.INSTANCE.config.controllerCapacity}));
        }
    }

    public static int getEnergyStored(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("Energy") ? stack.func_77978_p().func_74762_e("Energy") : 0;
    }

    public void func_77622_d(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        ItemBlockController.createStack(stack, 0);
    }

    public static ItemStack createStack(ItemStack stack, int energy) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74768_a("Energy", stack.func_77960_j() == ControllerType.CREATIVE.getId() ? RS.INSTANCE.config.controllerCapacity : energy);
        stack.func_77982_d(tag);
        return stack;
    }
}

